/** @file   teleporter.cpp
 * @brief   Implementation of Teleporter - class.
 * @version $Revision: 1.3 $
 * @author  Tomi Lamminsaari
 */

#include "teleporter.h"
using namespace eng2d;
using std::vector;
using std::istream;
using std::string;

namespace WeWantWar {


/** Constructor
 */
Teleporter::Teleporter() :
  m_targetPos( 0,0 ),
  m_targetAngle( 0 ),
  m_makeSound( -1 ),
  m_id( 0 )
{
}



/** Destructor
 */
Teleporter::~Teleporter()
{
}


/** Checks and does the teleportation if given object is inside the
 * area.
 */
void Teleporter::teleport( GameObject* pObj ) const
{
  if ( m_rect.pointInside( pObj->position() ) == false ) {
    return;
  }
  
  pObj->position( m_targetPos );
  pObj->angle( m_targetAngle );
  
  // Now we make the teleporting sound.
  if ( pObj->objectType() == ObjectID::TYPE_PLAYER ) {
    if ( m_makeSound != -1 ) {
      Sound::playSample( m_makeSound, false );
    }
  }
}



} // end of namespace
